function JFindDialog(owner, parent, name, caption, action, method, rect, previous)
{
	var self = this,
	_rendered = false,
	_disposed = false,
	_dragHandler = null;

	this.initialize(owner, parent, name, caption, action, rect, null);

	this.isForm   = true;
	this.method   = method;
	this.previous = previous;
	this.methods  = (cmRender | cmLoad);

	this.local    = null;
	this.collist  = [];
	this.confirm  = null;
	this.cancel   = null;
	this.combo    = null;
	this.options  = null;
	this.edit     = null;
	this.labels   = [];

	this.owner.addImage("close-icon", "close.gif", "form");
	this.owner.addImage("checkbox-on",  "checkbox-on.gif",  "controls");
	this.owner.addImage("checkbox-off", "checkbox-off.gif", "controls");

	this.render  = render;
	this.load    = load;
	this.change  = change;
	this.close   = close;
	this.dispose = dispose;
	this.isRendered = isRendered;

	this.rect.normalize(this.owner.getDocument().body);

	this.owner.activeForm = this;


	function render(fs)
	{
		if (_rendered)
			return;

		var rectConfirm = utils.format("%1;%2;%3;%4", self.rect.width - 155, self.rect.height - 60, 60, 24);
		var rectCancel  = utils.format("%1;%2;%3;%4", self.rect.width -  85, self.rect.height - 60, 60, 24);
		var previous    = self.owner.getObject(self.previous);
		var prevDS = previous.dataset;
		if (previous.activeControl != null)
			prevDS = previous.activeControl.dataset;

		if ((self.confirm == null) && (self.cancel == null))
		{
			self.confirm = self.owner.registerObject(self.name + "_confirm", new JButton(self.owner, self.name, self.name + "_confirm", self.owner.localize("capOK"),     true, rectConfirm, raCloseParent, null));
			self.cancel  = self.owner.registerObject(self.name + "_cancel",  new JButton(self.owner, self.name, self.name + "_cancel",  self.owner.localize("capCancel"), true, rectCancel,  raCloseParent, null));
			self.addControl(self.confirm);
			self.addControl(self.cancel);
		}

		if (self.collist.length == 0)
		{
			var items  = [];
			var fields = prevDS.fields;
			
			fields = utils.sortObj(fields);
			
			for (var i = 0; i < fields.length; i++) {
				var field = fields[i].value;
				var fldName = fields[i].key;
				if (!utils.inSet(ffHidden, field.flags))
				{
					self.collist[self.collist.length++] = fldName;
					items[items.length++] = (items.length - 1) + "=" + field.caption;
				}

			}
/*
			fields.forIn( function (field, fldName)
			{
				if (!utils.inSet(ffHidden, field.flags))
				{
					self.collist[self.collist.length++] = fldName;
					items[items.length++] = (items.length - 1) + "=" + field.caption;
				}
			}, self);
*/
			var optset = utils.format("1=%1;2=%2;4=%3;8=%4;16=%5", self.owner.localize("optContaining"), self.owner.localize("optLeft"), self.owner.localize("optCaseSensitive"), self.owner.localize("optPrior"), self.owner.localize("optCyclic"));

			self.local = self.owner.registerObject("__" + self.name + "_local", new JDataset(self.owner, self.name, "__" + self.name + "_local", "", "", dfNone));
			self.local.addField(new JField("fld", "", ftEnum,   items.join(';'), ffRequired));
			self.local.addField(new JField("val", "", ftString, "",              ffNone));
			self.local.addField(new JField("opt", "", ftSet,    optset,          ffRequired));
			self.local.loadRecord("add", "", "fld=0%17val=%17opt=18%17", rsUnchanged, rfNone, true);
		}

		if ((self.combo == null) && (self.edit == null) && (self.options == null))
		{
			self.labels["lab_1"] = self.owner.registerObject(self.name + "_lab_1", new JLabel(self.owner, self.name, self.name + "_lab_1", null, null, self.owner.localize("capAttribute"), laLeft, "10;22;60;21", null));
			self.combo = self.owner.registerObject(self.name + "_combo", new JEnumPicker(self.owner, self.name, self.name + "_combo", self.local, "fld", "75;15;250;21", null));
			self.labels["lab_2"] = self.owner.registerObject(self.name + "_lab_2", new JLabel(self.owner, self.name, self.name + "_lab_2", null, null, self.owner.localize("capValue"), laLeft, "10;52;60;21", null));
			self.edit = self.owner.registerObject(self.name + "_edit",  new JEdit(self.owner, self.name, self.name + "_edit", self.local, "val", "75;45;250;21", etSimple, null));

			if ((previous.lastFindValue != null) && (self.edit != null))
						self.edit.value = previous.lastFindValue;

			self.labels["lab_3"] = self.owner.registerObject(self.name + "_lab_3", new JLabel(self.owner, self.name, self.name + "_lab_3", null, null, self.owner.localize("capOptions"), laLeft, "10;82;60;21", null));
			self.options = self.owner.registerObject(self.name + "_options", new JSetPicker(self.owner, self.name, self.name + "_options", self.local, "opt", "75;75;250;21", null));

			self.combo.onchange.attach(self.change);

			self.addControl(self.labels["lab_1"]);
			self.addControl(self.labels["lab_2"]);
			self.addControl(self.labels["lab_3"]);
			self.addControl(self.combo);
			self.addControl(self.options);

		}

		fs.append( '<div class="dialogForm" id="' + self.name + '" style="' + self.rect + '">');

		fs.append('  <div id="' + self.name + '_title" class="form_titlebar">');
		fs.append('    <span id="' + self.name + '_caption" class="form_caption">' + self.caption + '</span>');
		fs.append('  </div>');

		fs.append(   '<div class="dialogForm_inlet" id="' + self.name + '_inlet" style="top: ' + (fmDragbarHeight + fmBorderWidth) + 'px; height: ' + (self.rect.height - fmDragbarHeight - 3 * fmBorderWidth) + 'px; width: ' + (self.rect.width - 2 * fmBorderWidth) + 'px">');

		if (self.local != null)
		{
			self.local.set("fld", (previous.lastFindField == null ? 0 : previous.lastFindField));
			self.local.set("val", (previous.lastFindValue == null ? "" : previous.lastFindValue));
			self.local.set("opt", (previous.lastFindOpt == null ? 18 : previous.lastFindOpt));
		}

		self.controls.forEach (function (control)
		{
			if (utils.inSet(cmRender, control.methods))
			{
				control.render(fs);
			}
		}, self);

		fs.append( '<div id="' + self.name + '_box" style="' + self.edit.rect + '">');
		self.edit.render(fs);
		fs.append('</div>');

		fs.append(   '</div>');
		fs.append( '</div>');

		_rendered = true;
	}

	function load()
	{
		if (self.dataset.fields.length == 0)
			self.$$('_confirm').disabled = 'true';

		self.owner.getDocument().body.appendChild(self.$$());

		self.controls.forEach (function (control)
		{
			if (utils.inSet(cmLoad, control.methods))
				control.load();
		}, self);
		self.edit.load();

		self.owner.splash(true);
		self.owner.setSplashInfo('');

		if (typeof(DragHandler) != 'undefined')
			_dragHandler = new DragHandler(self.$$(), self.$$('_title'));
	}

	function change()
	{
		/* this. is used because this method is called in scope of EnumPicker */

		this.save();

		var afm = self; //this.owner.getObject(this.parent);
		var pfm = this.owner.getObject(afm.previous);
		var pfmDS = pfm.dataset;
		if (pfm.activeControl != null)
			pfmDS = pfm.activeControl.dataset; 
		var afd = afm.local.fields["val"];
		var pfd = pfmDS.fields[afm.collist[this.value]];

		if (pfd == null)
			return;

		if (afm.edit != null)
		{
			afm.local.set("val", (pfm.lastFindValue == null ? "" : pfm.lastFindValue));

			afm.owner.unregisterObject(self.name + "_edit");
			afm.edit = null;
			afd.type = pfd.type;

			if (utils.inList(pfd.type, ftString, ftMemo, ftInteger, ftFloat))
			{
				afm.edit = afm.owner.registerObject(afm.name + "_edit", new JEdit(afm.owner, afm.name, self.name + "_edit", afm.local, "val", "75;45;250;21", etSimple, null));
			}
			else
			if (utils.inList(pfd.type, ftDate, ftTime, ftDateTime))
			{
				afm.edit = afm.owner.registerObject(afm.name + "_edit", new JCalendar(afm.owner, afm.name, self.name + "_edit", afm.local, "val", "75;45;250;21", null));
			}
			else
			if (pfd.type == ftEnum)
			{
				afd.items = pfd.items;
				afm.edit  = afm.owner.registerObject(afm.name + "_edit", new JEnumPicker(afm.owner, afm.name, self.name + "_edit", afm.local, "val", "75;45;250;21", null));
			}
			else
			if (pfd.type == ftSet)
			{
				afd.items = pfd.items;
				afm.edit  = afm.owner.registerObject(afm.name + "_edit", new JSetPicker(afm.owner, afm.name, self.name + "_edit", afm.local, "val", "75;45;250;21", null));
			}
		}

		if (afm.edit != null)
		{
			var fs = new FastString();
			afm.edit.render(fs);
			afm.$$("_box").innerHTML = fs.toString();
			afm.edit.load();
			if (afm.edit.setFocus)
				afm.edit.setFocus();
			else
			{
				if ((self.$$('_edit') != null) && (self.$$('_edit').focus))
					self.$$('_edit').focus();
			}
		}
	}

	function close(e)
	{
		self.owner.splash(false);
		self.$$().style.display = 'none';

		var element = utils.getEventElement(e);

		while (element.className != "button")
		{
			element = element.parentNode;
		}

		switch (element.id)
		{
			case self.name + "_confirm":
				self.$$().style.borderStyle = "outset";
				var afmobj = self.owner.activeForm;
				var pfmobj = self.owner.getObject(self.previous);
				var pfmDS = pfmobj.dataset;
				if (pfmobj.activeControl != null)
					pfmDS = pfmobj.activeControl.dataset;
				var query = new Postback();

				var allChildren = pfmobj.getAllControls();
				allChildren.forEach(function(child)
				{
					if ((child.constructor == JGrid) && (child.dataset.name == pfmDS.name))
						child.selectedRows.clear();
				}, self);

				query.set("dat", escape(afmobj.dataset.getCurrentRecord().toString()));
				query.set("fid", self.collist[self.local.get("fld")]);
				if (pfmDS.getCurrentRecord() != null)
					query.set("rec", pfmDS.getCurrentRecord().key);
				query.set("pfm", pfmobj.name);
				query.set("pds", pfmDS.name);

				pfmobj.lastFindValue = self.local.get("val"); //self.edit.value;
				pfmobj.lastFindField = self.local.get("fld"); //self.combo.value;
				pfmobj.lastFindOpt = self.local.get("opt"); //self.edit.value;

				self.owner.post(raSetSearch, query);

				break;

			case self.name + "_cancel" :
				self.owner.unregisterObject(self.name);
				break;
		}
	}

	function isRendered()
	{
	  return _rendered;
	}

	function dispose()
	{
		if (_disposed)
			return;

		if (_dragHandler != null)
			_dragHandler.dispose();

		self.disposeChildren();
		self.local.dispose();
		self.local = null;
		self.edit.dispose();
		self.edit = null;
		self.collist  = [];
		self.labels = [];

		if (self.$$().parentNode != null)
			self.$$().parentNode.removeChild(self.$$());

		self.base.dispose.call(self);
		_disposed = true;
	}

}

JFindDialog.inheritsFrom(ControlBase);

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();